function [nrst_data,full_data] = punc_distill_lite(distance,vector,lum,varargin)
%A Little function that takes the compressed data matrices produced by
%punc2mat, and using parameters provided by the user distill the dataset
%further into a matrix of only pertinent data.
%Synatax:   [distilled_data] = punc_distill(distance,vector,'ori',1,...
%               'termi',2); 
%Input:     distance = distance data structure generated by punc2mat
%           vector = vector data structure generated by punc2mat
%           lum = luminance data structure generated by punc2mat
%           origin = the channel used to provide the origin of the base
%               vector, e.g., the channel providing the base pivots.
%           termini = the channel used to provide the termini of the base
%               vector, e.g., the channel used with the origin to make the
%               base vector.
%output:    full_data = one array of all of the parameters, i.e.,
%               distances and vectors and vector positions, for channal
%               origin_ch, which is the base pivot.
%           nrst_data = same as full_data except it only has the nearested
%               distance punctas

[ori,termi] = parse(varargin);     %Parse the input

%lets pull up the vector data and go.
full_data = [];    %initiate output array
nrst_data = [];
vector = vector(:,:,termi);     %get the relavent data only

%matlabpool

for i = 1:size(vector,1)    %step through all the vertices
    full_tmp = [];      %initiate temporary matrix not filtered by nearest distance
    nrst_tmp = [];      %initialize temporary matrix for holding the data filtered by nearest distance
    %lets get the terminal channel first
    %now pull out the data matrix of the channel to be analyzed
    [all_idx,col] = find(distance{:,1,termi}(:,1)==i);   %find the rows for current vertex
    curr_dist = distance{1,1,termi}(all_idx,:);    %pull out the distances for the current vertex
    curr_lum = lum{1,1,termi}(all_idx,:);       %pullout the lumninance data for the current vertex
    %make sure the data is not empty
    if isempty(curr_dist)
        curr_dist = NaN(1,9);
        curr_lum = NaN(1,9);
    end
    %now get the nearest data set
    if size(all_idx,1)~=1       %find nearest
        [nrst_idx,col] = find(curr_dist(:,9)==min(curr_dist(:,9)));        %find the shortest distance for the current vertex
        nrst_dist = curr_dist(nrst_idx,:);
        nrst_lum = curr_lum(nrst_idx,:);
        base_nrst_idx = nrst_idx;                   %save the nrst_idx of the base
    else                        %all_idx is the nearest
        nrst_dist = curr_dist;
        nrst_lum = curr_lum;
    end
    %now put distill the data
    full_tmp = horzcat(repmat(i,size(curr_dist,1),1),repmat(ori,size(curr_dist,1),1),curr_dist(:,2:5),repmat(termi,size(curr_dist,1),1),...
        curr_dist(:,6:end),curr_lum(:,9));   %all.
    nrst_tmp = horzcat(repmat(i,size(nrst_dist,1),1),repmat(ori,size(nrst_dist,1),1),nrst_dist(:,2:5),repmat(termi,size(nrst_dist,1),1),...
        nrst_dist(:,6:end),nrst_lum(:,9));   %nearest.
    base_idx = size(full_tmp,1);                %find the number of base vectors for vertex
    nrst_base_idx = size(nrst_tmp,1);           %unlikely, but just in case the number of nearest base vectors
    %now get all the other channels
    for j = 1:size(distance,3)  %step through the # of channels compared to the origin
        if j~=ori && j~=termi        %skip the origin channel because everything will be [] anyway & termi channel is already present
            %now pull out the data matrix of the channel to be analyzed
            [all_idx,col] = find(distance{:,1,j}(:,1)==i);   %find the rows for current vertex
            curr_dist = distance{1,1,j}(all_idx,:);    %pull out the distances for the current vertex
            curr_lum = lum{1,1,j}(all_idx,:);       %pull out the lumninance data for the current vertex
            curr_vector = vector{i,1}{:,:,j};            %pull out the vector data for the current vertex
            %make sure the data is not empty
            if isempty(curr_dist)
                curr_dist = NaN(1,9);
                curr_lum = NaN(1,9);
            end
            if isempty(curr_vector)
                curr_vector = NaN(size(curr_dist,1),15);
            end
            %now get the nearest data set
            if size(all_idx,1)~=1||base_idx~=1       %find nearest
                [nrst_idx,col] = find(curr_dist(:,9)==min(curr_dist(:,9)));        %find the shortest distance for the current vertex
                if isempty(nrst_idx) | nrst_idx==0      %NaN==NaN = 0, so if this happens our minimum index is 1
                    nrst_idx = 1;
                end
                nrst_dist = curr_dist(nrst_idx,:);
                nrst_lum = curr_lum(nrst_idx,:);
                if nrst_base_idx==1      %more than 1 base vectors, but only 1 base vector that is the nearest
                    if size(all_idx,1)==1 || base_idx==1      %there is only one nearest point in this channel
                        nrst_vector = curr_vector(nrst_idx,:);
                    else                        %there is more than one point in this channel, and there are multiple base vectors
                        %nrst_vector = curr_vector(nrst_idx*base_idx-base_idx+1:nrst_idx*base_idx,:);
                        %if size(all_idx,1)<=base_idx     %the number of vertices in this channel is less than the # of base vectors
                            curr_vec_tmp = curr_vector(base_nrst_idx*size(all_idx,1)-size(all_idx,1)+1:base_nrst_idx*size(all_idx,1),:);
                        %else            %the number of vertices in the channel is greater than the # of base vectors
                            %curr_vec_tmp = curr_vector(base_nrst_idx*base_idx-base_idx+1:base_nrst_idx*base_idx,:);
                            %curr_vec_tmp = curr_vector(base_nrst_idx*size(all_idx,1)-size(all_idx,1)+1:base_nrst_idx*size(all_idx,1),:);
                        %end
                        nrst_vector =  curr_vec_tmp(nrst_idx,:);
                        curr_vec_tmp = [];
                    end
                else                     %more than 1 base vectors and multiple are the same nearest distance
                    nrst_vector = [];
                    for o = 1:size(base_nrst_idx,1)
                        curr_vec_tmp = curr_vector(base_nrst_idx*size(all_idx,1)-size(all_idx,1)+1:base_nrst_idx*size(all_idx,1),:);
                        nrst_vector =  vertcat(nrst_vector,curr_vec_tmp(nrst_idx,:));
                        curr_vec_tmp = [];
                    end
                end
            else                        %all_idx is the nearest
                nrst_dist = curr_dist;
                nrst_lum = curr_lum;
                nrst_vector = curr_vector;
            end
            %now put together the data
            %full data set
                for k = 1:size(full_tmp,1)                  %step through the current output dataset rows
                    cache = [];         %initialize current cache.
                    if base_idx==1          %only 1 base vector
                        cache = horzcat(repmat(full_tmp(k,:),size(curr_vector,1),1),repmat(j,...
                            size(curr_vector,1),1),curr_vector(:,8:end),curr_dist(:,9),curr_lum(:,9));
                    else                    %more than 1 base vector
%                         curr_vec_idx = size(curr_vector,1)/base_idx;
%                         if size(full_tmp,1)>base_idx
%                             m = ceil(k/base_idx);
%                         else
%                             m = k;
%                         end
%                         cache = vertcat(cache,horzcat(repmat(full_tmp(k,:),curr_vec_idx,1),repmat(j,...
%                             curr_vec_idx,1),curr_vector(curr_vec_idx*m-curr_vec_idx+1:curr_vec_idx*m,8:end),curr_dist(:,9),curr_lum(:,9)));
                        cache = vertcat(cache,horzcat(repmat(full_tmp(k,:),size(curr_vector,1),1),repmat(j,...
                             size(curr_vector,1),1),curr_vector(:,8:end),repmat(curr_dist(:,9),...
                             size(curr_vector,1)/size(curr_dist,1),1),repmat(curr_lum(:,9),size(curr_vector,1)/size(curr_lum,1),1)));
                    end
                    if k~=1       %not first time through
                        d_tmp = vertcat(d_tmp,cache);     %combine matrix
                    else          %first timer
                        d_tmp = cache;       %data matrix
                    end
                end
            full_tmp = d_tmp;
            d_tmp = [];
            for l = 1:size(nrst_tmp,1)                  %step through the current output dataset rows
                cache = [];
                if nrst_base_idx==1
                    cache = horzcat(repmat(nrst_tmp(l,:),size(nrst_vector,1),1),repmat(j,...
                        size(nrst_vector,1),1),nrst_vector(:,8:end),nrst_dist(:,9),nrst_lum(:,9));
                else
%                     nrst_vec_idx = size(nrst_vector,1)/nrst_base_idx;
%                     if size(nrst_tmp,1)>nrst_base_idx
%                         n = ceil(l/nrst_base_idx);
%                     else
%                         n = l;
%                     end
%                     cache = vertcat(cache,horzcat(repmat(nrst_tmp(l,:),nrst_vec_idx,1),repmat(j,...
%                         nrst_vec_idx,1),nrst_vector(nrst_vec_idx*n-nrst_vec_idx+1:nrst_vec_idx*n,8:end),nrst_dist(:,9),nrst_lum(:,9)));
                     cache = vertcat(cache,horzcat(repmat(nrst_tmp(k,:),size(nrst_vector,1),1),repmat(j,...
                          size(nrst_vector,1),1),nrst_vector(:,8:end),repmat(nrst_dist(:,9),...
                          size(nrst_vector,1)/size(nrst_dist,1),1),repmat(nrst_lum(:,9),size(nrst_vector,1)/size(nrst_lum,1),1)));
                end
                if l~=1       %not first time through
                    d_tmp = vertcat(d_tmp,cache);     %combine matrix
                else          %first timer
                    d_tmp = cache;       %data matrix
                end
            end
            nrst_tmp = d_tmp;
            d_tmp = []; cache = [];
        end
    end
    %store away the data in  the full data matrix
    full_data = vertcat(full_data,full_tmp);      %add data to the array
    nrst_data = vertcat(nrst_data,nrst_tmp);
        
    nrst_tmp = []; nrst_dist = []; nrst_lum = []; nrst_vector = []; full_tmp = []; full_dist = [];
    full_lum = []; curr_vector = []; curr_dist = []; curr_lum = [];
end

%matlabpool close

%--------------------------------------------------------------------------
%subfunction to parse the inputs.
function [ori,termi,vector_param,dist] = parse(input)

ori = 1;  %Default Initialized.
termi = 2;  %Center is off at default

%Parse the input
if ~isempty(input)
    for i = 1:size(input,2)
        if ischar(input{1,i});
            switch input{1,i}
                case 'ori'
                    ori = input{1,i+1};
                case 'termi'
                    termi = input{1,i+1};
                otherwise
                    %error
                    warning(['Your input ',input{1,i},' is not recognized.']);
            end
        end
    end
end